<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">
    <link rel="shortcut icon" type="image/x-icon" href="<?= base_url('assets/img/favicon.ico') ?>">
    <title>Ubumi - Login</title>
    <link rel="stylesheet" href="<?= base_url('assets/css/bootstrap.min.css') ?>">
    <link rel="stylesheet" href="<?= base_url('assets/css/font-awesome.min.css') ?>">
    <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
</head>
<body>
    <div class="main-wrapper account-wrapper">
        <div class="account-page">
            <div class="account-center">
                <div class="account-box">

                    <!-- FLASH MESSAGE -->
                    <?php if(session()->getFlashdata('fail')): ?>
                        <div class="alert alert-danger text-center">
                            <?= session()->getFlashdata('fail') ?>
                        </div>
                    <?php endif; ?>

                    <form action="<?= base_url('/login') ?>" method="post" class="form-signin">
                        <?= csrf_field() ?>
                        <div class="account-logo">
                            <a href="#"><img src="<?= base_url('assets/img/logo-dark.png') ?>" alt="Logo"></a>
                        </div>

                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" required class="form-control" placeholder="Enter email">
                        </div>

                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" name="password" required class="form-control" placeholder="Enter password">
                        </div>

                        <div class="form-group text-right">
                            <a href="#">Forgot your password?</a>
                        </div>

                        <div class="form-group text-center">
                            <button type="submit" class="btn btn-primary account-btn">Login</button>
                        </div>

                        <div class="text-center register-link">
                            Don’t have an account? <a href="#">Register Now</a>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>

    <script src="<?= base_url('assets/js/jquery-3.2.1.min.js') ?>"></script>
    <script src="<?= base_url('assets/js/popper.min.js') ?>"></script>
    <script src="<?= base_url('assets/js/bootstrap.min.js') ?>"></script>
    <script src="<?= base_url('assets/js/app.js') ?>"></script>
</body>
</html>
